<?php $content = app('App\Http\Controllers\FrontController'); ?>
<?php $__env->startSection('title', '<?php echo e($title); ?>'); ?>

<?php $__env->startSection('content'); ?>
<!-- Hero Section -->
<section class="relative overflow-hidden bg-gradient-to-br from-gray-900 to-gray-800">
    <!-- Abstract Background Elements -->
    <div class="absolute inset-0 z-0 pointer-events-none opacity-20">
        <!-- Abstract Indices Chart Pattern -->
        <div class="absolute top-0 right-0 w-full h-full">
            <svg class="absolute top-0 right-0 w-full h-full" viewBox="0 0 800 800" xmlns="http://www.w3.org/2000/svg">
                <defs>
                    <linearGradient id="indicesGrad1" x1="0%" y1="0%" x2="100%" y2="100%">
                        <stop stop-color="#3B82F6" stop-opacity=".25" offset="0%"/>
                        <stop stop-color="#EC4899" stop-opacity=".2" offset="50%"/>
                        <stop stop-color="#6366F1" stop-opacity=".15" offset="100%"/>
                    </linearGradient>
                </defs>
                <!-- Indices chart-inspired shape -->
                <path d="M100,600 L200,550 L300,580 L400,500 L500,520 L600,480 L700,400"
                      stroke="url(#indicesGrad1)"
                      fill="none"
                      stroke-width="8"
                      stroke-linecap="round"
                      stroke-linejoin="round"/>

                <!-- Background grid lines -->
                <g stroke="currentColor" stroke-opacity="0.1">
                    <line x1="0" y1="100" x2="800" y2="100" />
                    <line x1="0" y1="200" x2="800" y2="200" />
                    <line x1="0" y1="300" x2="800" y2="300" />
                    <line x1="0" y1="400" x2="800" y2="400" />
                    <line x1="0" y1="500" x2="800" y2="500" />
                    <line x1="0" y1="600" x2="800" y2="600" />
                    <line x1="0" y1="700" x2="800" y2="700" />

                    <line x1="100" y1="0" x2="100" y2="800" />
                    <line x1="200" y1="0" x2="200" y2="800" />
                    <line x1="300" y1="0" x2="300" y2="800" />
                    <line x1="400" y1="0" x2="400" y2="800" />
                    <line x1="500" y1="0" x2="500" y2="800" />
                    <line x1="600" y1="0" x2="600" y2="800" />
                    <line x1="700" y1="0" x2="700" y2="800" />
                </g>
            </svg>
        </div>
    </div>

    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 relative z-10 py-24">
        <div class="grid grid-cols-1 lg:grid-cols-2 gap-12 items-center">
            <div>
                <div class="inline-block px-3 py-1 mb-6 text-xs font-semibold tracking-wider text-blue-400 uppercase bg-blue-900 bg-opacity-30 rounded-full">
                    Global Markets
                </div>
                <h1 class="text-4xl font-extrabold tracking-tight text-white sm:text-5xl md:text-6xl mb-6">
                    <span class="block">Global Indices</span>
                    <span class="block text-blue-400">Trading</span>
                </h1>
                <p class="mt-3 text-base text-gray-300 sm:mt-5 sm:text-xl lg:text-lg xl:text-xl max-w-xl">
                    See the complete list of world stock indexes with points and percentage change, volume, intraday highs and lows, 52 week range, and day charts.
                </p>
                <div class="mt-8 flex flex-wrap gap-4">
                    <a href="#indices-table" class="inline-flex items-center px-6 py-3 border border-transparent text-base font-medium rounded-md shadow-sm text-white bg-blue-600 hover:bg-blue-700 transition duration-300">
                        View Markets
                        <svg class="ml-2 -mr-1 h-5 w-5" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor">
                            <path fill-rule="evenodd" d="M16.707 10.293a1 1 0 010 1.414l-6 6a1 1 0 01-1.414 0l-6-6a1 1 0 111.414-1.414L9 14.586V3a1 1 0 012 0v11.586l4.293-4.293a1 1 0 011.414 0z" clip-rule="evenodd" />
                        </svg>
                    </a>
                    <a href="#" class="inline-flex items-center px-6 py-3 border border-gray-700 text-base font-medium rounded-md text-gray-300 bg-transparent hover:bg-gray-800 transition duration-300">
                        Learn More
                    </a>
                </div>
            </div>
            <div class="hidden lg:block">
                <div class="relative">
                    <div class="absolute -inset-0.5 bg-gradient-to-r from-blue-500 to-purple-600 rounded-lg blur opacity-30"></div>
                    <div class="relative bg-gray-800 bg-opacity-80 backdrop-blur-sm p-6 rounded-lg border border-gray-700">
                        <div class="flex justify-between items-center mb-6">
                            <div>
                                <span class="text-gray-400 text-sm">Major Index</span>
                                <h3 class="text-xl font-bold text-white">US 500</h3>
                            </div>
                            <div class="text-right">
                                <span class="text-green-400 text-xl font-bold">4,568.32</span>
                                <div class="flex items-center justify-end text-green-400">
                                    <svg class="w-4 h-4 mr-1" fill="currentColor" viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg">
                                        <path fill-rule="evenodd" d="M12 7a1 1 0 110-2h5a1 1 0 011 1v5a1 1 0 11-2 0V8.414l-4.293 4.293a1 1 0 01-1.414 0L8 10.414l-4.293 4.293a1 1 0 01-1.414-1.414l5-5a1 1 0 011.414 0L11 10.586 14.586 7H12z" clip-rule="evenodd"></path>
                                    </svg>
                                    <span class="text-sm">+0.23%</span>
                                </div>
                            </div>
                        </div>
                        <!-- Chart mockup -->
                        <div class="w-full h-48 relative">
                            <svg class="w-full h-full" viewBox="0 0 400 200" xmlns="http://www.w3.org/2000/svg">
                                <!-- Chart background -->
                                <defs>
                                    <linearGradient id="chartGradient" x1="0%" y1="0%" x2="0%" y2="100%">
                                        <stop offset="0%" stop-color="#3B82F6" stop-opacity="0.2"/>
                                        <stop offset="100%" stop-color="#3B82F6" stop-opacity="0"/>
                                    </linearGradient>
                                </defs>

                                <!-- Chart grid -->
                                <g stroke="#2D3748" stroke-width="0.5">
                                    <line x1="0" y1="40" x2="400" y2="40" />
                                    <line x1="0" y1="80" x2="400" y2="80" />
                                    <line x1="0" y1="120" x2="400" y2="120" />
                                    <line x1="0" y1="160" x2="400" y2="160" />
                                </g>

                                <!-- Chart line -->
                                <path d="M0,160 L40,150 L80,155 L120,140 L160,130 L200,120 L240,100 L280,105 L320,80 L360,70 L400,60"
                                      fill="none" stroke="#3B82F6" stroke-width="3" stroke-linecap="round" stroke-linejoin="round"/>

                                <!-- Chart area -->
                                <path d="M0,160 L40,150 L80,155 L120,140 L160,130 L200,120 L240,100 L280,105 L320,80 L360,70 L400,60 L400,200 L0,200 Z"
                                      fill="url(#chartGradient)"/>
                            </svg>
                        </div>

                        <!-- Stats -->
                        <div class="grid grid-cols-3 gap-2 mt-4">
                            <div class="bg-gray-900 bg-opacity-50 p-2 rounded">
                                <div class="text-xs text-gray-400">Open</div>
                                <div class="text-sm text-white">4,552.10</div>
                            </div>
                            <div class="bg-gray-900 bg-opacity-50 p-2 rounded">
                                <div class="text-xs text-gray-400">High</div>
                                <div class="text-sm text-white">4,575.28</div>
                            </div>
                            <div class="bg-gray-900 bg-opacity-50 p-2 rounded">
                                <div class="text-xs text-gray-400">Low</div>
                                <div class="text-sm text-white">4,545.36</div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Indices Table Section -->
<section id="indices-table" class="py-16 bg-gradient-to-b from-gray-900 to-gray-800 relative">
    <!-- Decorative background pattern -->
    <div class="absolute inset-0 z-0 opacity-10 pointer-events-none">
        <div class="absolute inset-0 bg-[url('data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iNjAiIGhlaWdodD0iNjAiIHZpZXdCb3g9IjAgMCA2MCA2MCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj48ZyBmaWxsPSJub25lIiBmaWxsLXJ1bGU9ImV2ZW5vZGQiPjxnIGZpbGw9IiNmZmYiIGZpbGwtb3BhY2l0eT0iLjMiPjxwYXRoIGQ9Ik0zNiAzNGgLTJWMjRoMnpNNDAgMjRoLTJ2MTBoMnpNNDQgMjRoLTJ2MTBoMnoiLz48L2c+PC9nPjwvc3ZnPg==')]"></div>
    </div>

    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 relative z-10">
        <div class="text-center mb-12">
            <div class="inline-block px-3 py-1 mb-4 text-xs font-semibold tracking-wider text-blue-400 uppercase bg-blue-900 bg-opacity-30 rounded-full">
                Market Overview
            </div>
            <h2 class="text-3xl font-extrabold text-white sm:text-4xl">
                <span class="block">Indices - Spreads &amp; Trading Conditions</span>
            </h2>
            <p class="mt-4 text-xl text-gray-300 max-w-3xl mx-auto">
                Access global index markets with competitive spreads and flexible trading conditions
            </p>
        </div>

        <!-- Search Bar -->
        <div class="max-w-3xl mx-auto mb-8 relative">
            <div class="relative">
                <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                    <svg class="h-5 w-5 text-gray-400" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor" aria-hidden="true">
                        <path fill-rule="evenodd" d="M8 4a4 4 0 100 8 4 4 0 000-8zM2 8a6 6 0 1110.89 3.476l4.817 4.817a1 1 0 01-1.414 1.414l-4.816-4.816A6 6 0 012 8z" clip-rule="evenodd" />
                    </svg>
                </div>
                <input type="text" class="search-box block w-full pl-10 pr-3 py-3 border border-gray-700 rounded-lg bg-gray-800 text-white placeholder-gray-400 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500" placeholder="Search all instruments">
                <span class="sr-only">Search instruments</span>
            </div>
        </div>

        <!-- Table Container with glass effect -->
        <div class="relative">
            <div class="absolute -inset-0.5 bg-gradient-to-r from-blue-500 to-indigo-600 rounded-xl blur opacity-20"></div>
            <div class="relative bg-gray-800 bg-opacity-80 backdrop-blur-sm rounded-xl p-6 overflow-hidden border border-gray-700">
                <div class="pat loading">
                    <div class="loader flex justify-center p-6">
                        <div class="w-12 h-12 border-4 border-blue-500 border-t-transparent rounded-full animate-spin"></div>
                        <span class="sr-only">Loading...</span>
                    </div>

                    <div class="overflow-x-auto">
                        <table id="tt-spreads-6023e311aa22a" class="display no-wrap tbl-spreads min-w-full divide-y divide-gray-700">
                            <thead class="bg-gray-800">
                                <tr>
                                    <th scope="col" data-key="Symbol" class="symbol px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider">Symbol</th>
                                    <th scope="col" data-key="Leverage" class="leverage px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider">Leverage</th>
                                    <th scope="col" data-key="Lot Size" class="lot_size px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider">Lot Size</th>
                                    <th scope="col" data-key="Min Lot Size" class="min_lot_size px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider">Min Lot Size</th>
                                    <th scope="col" data-key="Commission" class="commission px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider">Commission</th>
                                </tr>
                            </thead>
                            <tbody class="bg-gray-800 divide-y divide-gray-700 text-gray-200">
                                <tr class="hover:bg-gray-700 transition-colors duration-150 ease-in-out">
                                    <td class="symbol px-6 py-4 whitespace-nowrap"><a class="text-blue-400 hover:text-blue-300" title="AUSTRALIA 200" href=""> AUSTRALIA 200 </a></td>
                                    <td class="symbol px-6 py-4 whitespace-nowrap">1:200</td>
                                    <td class="leverage px-6 py-4 whitespace-nowrap">1 * index price</td>
                                    <td class="lot_size px-6 py-4 whitespace-nowrap">0.01</td>
                                    <td class="min_lot_size px-6 py-4 whitespace-nowrap">0</td>
                                </tr>
                                <tr class="hover:bg-gray-700 transition-colors duration-150 ease-in-out">
                                    <td class="symbol px-6 py-4 whitespace-nowrap"><a class="text-blue-400 hover:text-blue-300" title="EUROPE 50" href=""> EUROPE 50 </a></td>
                                    <td class="symbol px-6 py-4 whitespace-nowrap">1:200</td>
                                    <td class="leverage px-6 py-4 whitespace-nowrap">1 * index price</td>
                                    <td class="lot_size px-6 py-4 whitespace-nowrap">0.01</td>
                                    <td class="min_lot_size px-6 py-4 whitespace-nowrap">0</td>
                                </tr>
                                <tr class="hover:bg-gray-700 transition-colors duration-150 ease-in-out">
                                    <td class="symbol px-6 py-4 whitespace-nowrap"><a class="text-blue-400 hover:text-blue-300" title="FRANCE 40" href=" "> FRANCE 40 </a></td>
                                    <td class="symbol px-6 py-4 whitespace-nowrap">1:200</td>
                                    <td class="leverage px-6 py-4 whitespace-nowrap">1 * index price</td>
                                    <td class="lot_size px-6 py-4 whitespace-nowrap">0.01</td>
                                    <td class="min_lot_size px-6 py-4 whitespace-nowrap">0</td>
                                </tr>
                                <tr class="hover:bg-gray-700 transition-colors duration-150 ease-in-out">
                                    <td class="symbol px-6 py-4 whitespace-nowrap"><a class="text-blue-400 hover:text-blue-300" title="GERMANY 30" href=""> GERMANY 30 </a></td>
                                    <td class="symbol px-6 py-4 whitespace-nowrap">1:200</td>
                                    <td class="leverage px-6 py-4 whitespace-nowrap">1 * index price</td>
                                    <td class="lot_size px-6 py-4 whitespace-nowrap">0.01</td>
                                    <td class="min_lot_size px-6 py-4 whitespace-nowrap">0</td>
                                </tr>
                                <tr class="hover:bg-gray-700 transition-colors duration-150 ease-in-out">
                                    <td class="symbol px-6 py-4 whitespace-nowrap"><a class="text-blue-400 hover:text-blue-300" title="HONG KONG 50" href=""> HONG KONG 50 </a></td>
                                    <td class="symbol px-6 py-4 whitespace-nowrap">1:200</td>
                                    <td class="leverage px-6 py-4 whitespace-nowrap">1 * index price</td>
                                    <td class="lot_size px-6 py-4 whitespace-nowrap">0.01</td>
                                    <td class="min_lot_size px-6 py-4 whitespace-nowrap">0</td>
                                </tr>
                                <tr class="hover:bg-gray-700 transition-colors duration-150 ease-in-out">
                                    <td class="symbol px-6 py-4 whitespace-nowrap"><a class="text-blue-400 hover:text-blue-300" title="ITALY 40" href=""> ITALY 40 </a></td>
                                    <td class="symbol px-6 py-4 whitespace-nowrap">1:200</td>
                                    <td class="leverage px-6 py-4 whitespace-nowrap">1 * index price</td>
                                    <td class="lot_size px-6 py-4 whitespace-nowrap">0.01</td>
                                    <td class="min_lot_size px-6 py-4 whitespace-nowrap">0</td>
                                </tr>
                                <tr class="hover:bg-gray-700 transition-colors duration-150 ease-in-out">
                                    <td class="symbol px-6 py-4 whitespace-nowrap"><a class="text-blue-400 hover:text-blue-300" title="JAPAN 225" href="#"> JAPAN 225 </a></td>
                                    <td class="symbol px-6 py-4 whitespace-nowrap">1:200</td>
                                    <td class="leverage px-6 py-4 whitespace-nowrap">1 * index price</td>
                                    <td class="lot_size px-6 py-4 whitespace-nowrap">0.01</td>
                                    <td class="min_lot_size px-6 py-4 whitespace-nowrap">0</td>
                                </tr>
                                <tr class="hover:bg-gray-700 transition-colors duration-150 ease-in-out">
                                    <td class="symbol px-6 py-4 whitespace-nowrap"><a class="text-blue-400 hover:text-blue-300" title="NETHERLANDS 25" href="#"> NETHERLANDS 25 </a></td>
                                    <td class="symbol px-6 py-4 whitespace-nowrap">1:200</td>
                                    <td class="leverage px-6 py-4 whitespace-nowrap">1 * index price</td>
                                    <td class="lot_size px-6 py-4 whitespace-nowrap">1</td>
                                    <td class="min_lot_size px-6 py-4 whitespace-nowrap">0</td>
                                </tr>
                                <tr class="hover:bg-gray-700 transition-colors duration-150 ease-in-out">
                                    <td class="symbol px-6 py-4 whitespace-nowrap"><a class="text-blue-400 hover:text-blue-300" title="SPAIN 35" href="#"> SPAIN 35 </a></td>
                                    <td class="symbol px-6 py-4 whitespace-nowrap">1:200</td>
                                    <td class="leverage px-6 py-4 whitespace-nowrap">1 * index price</td>
                                    <td class="lot_size px-6 py-4 whitespace-nowrap">0.01</td>
                                    <td class="min_lot_size px-6 py-4 whitespace-nowrap">0</td>
                                </tr>
                                <tr class="hover:bg-gray-700 transition-colors duration-150 ease-in-out">
                                    <td class="symbol px-6 py-4 whitespace-nowrap"><a class="text-blue-400 hover:text-blue-300" title="SWITZERLAND 20" href="#"> SWITZERLAND 20 </a></td>
                                    <td class="symbol px-6 py-4 whitespace-nowrap">1:200</td>
                                    <td class="leverage px-6 py-4 whitespace-nowrap">1 * index price</td>
                                    <td class="lot_size px-6 py-4 whitespace-nowrap">0.01</td>
                                    <td class="min_lot_size px-6 py-4 whitespace-nowrap">0</td>
                                </tr>
                                <tr class="hover:bg-gray-700 transition-colors duration-150 ease-in-out">
                                    <td class="symbol px-6 py-4 whitespace-nowrap"><a class="text-blue-400 hover:text-blue-300" title="UK 100" href="#"> UK 100 </a></td>
                                    <td class="symbol px-6 py-4 whitespace-nowrap">1:200</td>
                                    <td class="leverage px-6 py-4 whitespace-nowrap">1 * index price</td>
                                    <td class="lot_size px-6 py-4 whitespace-nowrap">0.01</td>
                                    <td class="min_lot_size px-6 py-4 whitespace-nowrap">0</td>
                                </tr>
                                <tr class="hover:bg-gray-700 transition-colors duration-150 ease-in-out">
                                    <td class="symbol px-6 py-4 whitespace-nowrap"><a class="text-blue-400 hover:text-blue-300" title="US 30" href="#"> US 30 </a></td>
                                    <td class="symbol px-6 py-4 whitespace-nowrap">1:200</td>
                                    <td class="leverage px-6 py-4 whitespace-nowrap">1 * index price</td>
                                    <td class="lot_size px-6 py-4 whitespace-nowrap">0.01</td>
                                    <td class="min_lot_size px-6 py-4 whitespace-nowrap">0</td>
                                </tr>
                                <tr class="hover:bg-gray-700 transition-colors duration-150 ease-in-out">
                                    <td class="symbol px-6 py-4 whitespace-nowrap"><a class="text-blue-400 hover:text-blue-300" title="US 500" href="#"> US 500 </a></td>
                                    <td class="symbol px-6 py-4 whitespace-nowrap">1:200</td>
                                    <td class="leverage px-6 py-4 whitespace-nowrap">1 * index price</td>
                                    <td class="lot_size px-6 py-4 whitespace-nowrap">0.01</td>
                                    <td class="min_lot_size px-6 py-4 whitespace-nowrap">0</td>
                                </tr>
                                <tr class="hover:bg-gray-700 transition-colors duration-150 ease-in-out">
                                    <td class="symbol px-6 py-4 whitespace-nowrap"><a class="text-blue-400 hover:text-blue-300" title="US TECH 100"> US TECH 100 </a></td>
                                    <td class="symbol px-6 py-4 whitespace-nowrap">1:200</td>
                                    <td class="leverage px-6 py-4 whitespace-nowrap">1 * index price</td>
                                    <td class="lot_size px-6 py-4 whitespace-nowrap">0.01</td>
                                    <td class="min_lot_size px-6 py-4 whitespace-nowrap">0</td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>


<script type=text/javascript>
$(function() {
    var $dttble = $('#tt-spreads-6023e311aa22a').DataTable({
        "scrollY": "50vh",
        "scrollCollapse": true,
        "responsive": true,
        "paging": false,
        "ordering": false,
        "searching": true,
        "language": {
            "zeroRecords": "No matching records found"
        },
        "columnDefs": [
            { targets: [ 'category', 'sub_category' ], visible: false }
        ],
        "drawCallback": function(settings) {
            $('.dataTables_scrollHead').css('width', '100%');
            $('.dataTables_scrollHeadInner').css('width', '100%');
            $('.dataTables_scrollHeadInner').find('.dataTable').css('width', '100%');
        },
        initComplete: function() {
            $('.loader').hide();
            $('.pat').removeClass('loading');
            $('.search-box').keyup(function() {
                $dttble.search(this.value).draw();
            });
        }
    });

    var tabs = $('.tabs .tab').on('click', function($event) {
        $event.preventDefault();
        tabs.removeClass('current');
        $(this).addClass('current');
        var target = $(this).data('target');
        $('.tabs-content .tab-content').css({
            'height': 0,
            'display': 'none'
        }).parent().find('.' + target).css({
            'height': '100%',
            'display': 'block',
        });
        $dttble.columns.adjust().draw();
        return false;
    });

    $(window).on('load', function() {
        AOS.refresh();
        $dttble.columns.adjust().draw();
    });

    $(window).on('resize', function() {
        setTimeout(function() {
            AOS.refresh();
            $dttble.columns.adjust().draw();
        }, 250);
    });
});
</script>

<!-- Indices Trading Features Section -->
<section class="py-16 bg-gray-900">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="text-center mb-12">
            <div class="inline-block px-3 py-1 mb-4 text-xs font-semibold tracking-wider text-blue-400 uppercase bg-blue-900 bg-opacity-30 rounded-full">
                Key Benefits
            </div>
            <h2 class="text-3xl font-extrabold text-white sm:text-4xl">
                <span class="block">Why Trade Indices</span>
            </h2>
            <p class="mt-4 text-xl text-gray-300 max-w-3xl mx-auto">
                Discover the advantages of trading global indices on our platform
            </p>
        </div>

        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
            <!-- Feature 1 -->
            <div class="bg-gray-800 bg-opacity-50 backdrop-blur-sm border border-gray-700 rounded-xl p-6 transform transition-all duration-300 hover:translate-y-[-5px] hover:shadow-lg">
                <div class="w-12 h-12 bg-blue-600 bg-opacity-20 rounded-lg flex items-center justify-center mb-4">
                    <svg class="w-6 h-6 text-blue-400" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 12l3-3 3 3 4-4M8 21l4-4 4 4M3 4h18M4 4h16v12a1 1 0 01-1 1H5a1 1 0 01-1-1V4z"></path>
                    </svg>
                </div>
                <h3 class="text-xl font-bold text-white mb-3">Diversified Exposure</h3>
                <p class="text-gray-300">Trade indices to gain exposure to entire market sectors rather than individual stocks, allowing for diversified risk and greater market opportunities.</p>
            </div>

            <!-- Feature 2 -->
            <div class="bg-gray-800 bg-opacity-50 backdrop-blur-sm border border-gray-700 rounded-xl p-6 transform transition-all duration-300 hover:translate-y-[-5px] hover:shadow-lg">
                <div class="w-12 h-12 bg-blue-600 bg-opacity-20 rounded-lg flex items-center justify-center mb-4">
                    <svg class="w-6 h-6 text-blue-400" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                    </svg>
                </div>
                <h3 class="text-xl font-bold text-white mb-3">Competitive Spreads</h3>
                <p class="text-gray-300">Trade major global indices with tight spreads and low costs, maximizing your potential returns on both long and short positions.</p>
            </div>

            <!-- Feature 3 -->
            <div class="bg-gray-800 bg-opacity-50 backdrop-blur-sm border border-gray-700 rounded-xl p-6 transform transition-all duration-300 hover:translate-y-[-5px] hover:shadow-lg">
                <div class="w-12 h-12 bg-blue-600 bg-opacity-20 rounded-lg flex items-center justify-center mb-4">
                    <svg class="w-6 h-6 text-blue-400" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 7h8m0 0v8m0-8l-8 8-4-4-6 6"></path>
                    </svg>
                </div>
                <h3 class="text-xl font-bold text-white mb-3">Extended Trading Hours</h3>
                <p class="text-gray-300">Access global indices markets with extended hours, allowing you to capitalize on opportunities around the clock across different time zones.</p>
            </div>
        </div>
    </div>
</section>
<script>
    $('.panel-collapse').on('show.bs.collapse', function() {
        $(this).siblings('.panel-heading').addClass('active');
    });
    $('.panel-collapse').on('hide.bs.collapse', function() {
        $(this).siblings('.panel-heading').removeClass('active');
    });
</script>

<!-- Trading Advantages Section -->
<section class="py-16 bg-gradient-to-b from-gray-800 to-gray-900">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="grid grid-cols-1 lg:grid-cols-2 gap-12 items-center">
            <div class="relative" data-aos="fade-right" data-aos-duration="1200">
                <div class="absolute -inset-0.5 bg-gradient-to-r from-blue-500 to-indigo-600 rounded-xl blur opacity-30"></div>
                <div class="relative bg-gray-800 bg-opacity-80 backdrop-blur-sm rounded-xl p-6 overflow-hidden border border-gray-700">
                    <img src="temp/custom/img/commission-scheme-crypt1t1.png" alt="commission-scheme" class="w-full h-auto rounded-lg">

                    <!-- Interactive Chart Overlay -->
                    <div class="absolute inset-0 bg-gradient-to-br from-gray-900/70 to-transparent flex items-center justify-center opacity-0 hover:opacity-100 transition-opacity duration-300">
                        <div class="text-center">
                            <div class="inline-flex items-center justify-center w-16 h-16 rounded-full bg-blue-600 bg-opacity-30 mb-4">
                                <svg class="w-8 h-8 text-blue-400" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 10l4.553-2.276A1 1 0 0121 8.618v6.764a1 1 0 01-1.447.894L15 14M5 18h8a2 2 0 002-2V8a2 2 0 00-2-2H5a2 2 0 00-2 2v8a2 2 0 002 2z"></path>
                                </svg>
                            </div>
                            <p class="text-white text-lg font-medium">View Market Analysis</p>
                        </div>
                    </div>
                </div>
            </div>

            <div>
                <div class="inline-block px-3 py-1 mb-4 text-xs font-semibold tracking-wider text-blue-400 uppercase bg-blue-900 bg-opacity-30 rounded-full">
                    Premium Trading Experience
                </div>
                <h2 class="text-3xl font-extrabold text-white sm:text-4xl mb-6">
                    <span class="block">Trade what you want,</span>
                    <span class="block">When you want</span>
                </h2>

                <p class="text-xl text-gray-300 mb-6">
                    One of the primary goals of our platform is to provide the best product in the market. Our relationships with leading tier one financial institutions mean deep liquidity and tighter spreads for indices traders.
                </p>

                <ul class="space-y-4">
                    <li class="flex items-start">
                        <div class="flex-shrink-0 mt-1">
                            <svg class="h-6 w-6 text-green-400" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z" />
                            </svg>
                        </div>
                        <p class="ml-3 text-lg text-gray-300">
                            Trade Forex, Indices, Shares & Commodities
                        </p>
                    </li>
                    <li class="flex items-start">
                        <div class="flex-shrink-0 mt-1">
                            <svg class="h-6 w-6 text-green-400" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z" />
                            </svg>
                        </div>
                        <p class="ml-3 text-lg text-gray-300">
                            Access global markets 24 hours / 7 days
                        </p>
                    </li>
                    <li class="flex items-start">
                        <div class="flex-shrink-0 mt-1">
                            <svg class="h-6 w-6 text-green-400" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z" />
                            </svg>
                        </div>
                        <p class="ml-3 text-lg text-gray-300">
                            Multilingual customer support
                        </p>
                    </li>
                    <li class="flex items-start">
                        <div class="flex-shrink-0 mt-1">
                            <svg class="h-6 w-6 text-green-400" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z" />
                            </svg>
                        </div>
                        <p class="ml-3 text-lg text-gray-300">
                            Trade on the go on our mobile apps
                        </p>
                    </li>
                </ul>

                <div class="mt-8">
                    <a href="trading-conditions" title="Learn About Trading Commissions" class="inline-flex items-center px-6 py-3 border border-transparent text-base font-medium rounded-md shadow-sm text-white bg-blue-600 hover:bg-blue-700 transition duration-300">
                        Trading Conditions
                        <svg class="ml-2 -mr-1 w-5 h-5" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M14 5l7 7m0 0l-7 7m7-7H3" />
                        </svg>
                    </a>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- CTA Section -->
<section class="py-16 bg-gray-900">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="relative overflow-hidden rounded-3xl bg-gradient-to-r from-blue-600 to-indigo-600">
            <div class="absolute inset-0 overflow-hidden opacity-20">
                <svg class="absolute bottom-0 left-0 transform translate-y-1/2 -translate-x-1/2 lg:bottom-0 lg:translate-y-0 lg:translate-x-0" width="800" height="800" fill="none" viewBox="0 0 400 400">
                    <defs>
                        <pattern id="e9033f3e-f665-41a6-84ef-756f6778e6fe" x="0" y="0" width="20" height="20" patternUnits="userSpaceOnUse">
                            <rect x="0" y="0" width="4" height="4" fill="currentColor" />
                        </pattern>
                    </defs>
                    <rect width="800" height="800" fill="url(#e9033f3e-f665-41a6-84ef-756f6778e6fe)" />
                </svg>
                <svg class="absolute top-0 right-0 transform -translate-y-1/2 translate-x-1/2 lg:top-0 lg:translate-y-0 lg:translate-x-0" width="800" height="800" fill="none" viewBox="0 0 400 400">
                    <defs>
                        <pattern id="e9033f3e-f665-41a6-84ef-756f6778e6ff" x="0" y="0" width="20" height="20" patternUnits="userSpaceOnUse">
                            <rect x="0" y="0" width="4" height="4" fill="currentColor" />
                        </pattern>
                    </defs>
                    <rect width="800" height="800" fill="url(#e9033f3e-f665-41a6-84ef-756f6778e6ff)" />
                </svg>
            </div>
            <div class="relative px-6 py-12 sm:py-16 sm:px-12 lg:px-16">
                <div class="md:ml-auto md:w-1/2 md:pl-10">
                    <div class="text-base max-w-prose mx-auto lg:max-w-none">
                        <span class="text-sm font-semibold text-white uppercase tracking-wider">Start Trading Today</span>
                        <h2 class="mt-2 text-3xl leading-8 font-extrabold tracking-tight text-white sm:text-4xl">Ready to Trade Indices?</h2>
                    </div>
                    <div class="mt-6 prose prose-indigo prose-lg text-white">
                        <p>Join thousands of traders worldwide who trade global indices on our platform. Get started with a free demo account or open a real trading account today.</p>
                    </div>
                    <div class="mt-8 flex space-x-4">
                        <a href="#" class="inline-flex items-center px-6 py-3 border border-transparent text-base font-medium rounded-md shadow-sm text-indigo-600 bg-white hover:bg-gray-100 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-white focus:ring-offset-indigo-600">
                            Create Account
                        </a>
                        <a href="#" class="inline-flex items-center px-6 py-3 border border-transparent text-base font-medium rounded-md text-white bg-indigo-800 bg-opacity-60 hover:bg-opacity-70 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500">
                            Try Demo
                        </a>
                    </div>
                </div>
            </div>
            <div class="hidden md:block absolute top-1/2 left-0 transform -translate-y-1/2 -translate-x-1/3">
                <svg width="404" height="344" fill="none" viewBox="0 0 404 344">
                    <defs>
                        <pattern id="85737c0e-0916-41d7-917f-596dc7edfa27" x="0" y="0" width="20" height="20" patternUnits="userSpaceOnUse">
                            <rect x="0" y="0" width="4" height="4" class="text-white" fill="currentColor" />
                        </pattern>
                    </defs>
                    <rect width="404" height="344" fill="url(#85737c0e-0916-41d7-917f-596dc7edfa27)" />
                </svg>
            </div>
            <div class="hidden md:block absolute bottom-0 right-0 transform translate-y-1/3 translate-x-1/3">
                <svg width="404" height="344" fill="none" viewBox="0 0 404 344">
                    <defs>
                        <pattern id="85737c0e-0916-41d7-917f-596dc7edfa28" x="0" y="0" width="20" height="20" patternUnits="userSpaceOnUse">
                            <rect x="0" y="0" width="4" height="4" class="text-white" fill="currentColor" />
                        </pattern>
                    </defs>
                    <rect width="404" height="344" fill="url(#85737c0e-0916-41d7-917f-596dc7edfa28)" />
                </svg>
            </div>
        </div>
    </div>
</section>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.base', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/milesinv/azizatradefxlive.com/resources/views/home/indices.blade.php ENDPATH**/ ?>